/*
 
 Copyright (c) 2004 PXI Project Team
 
 Permission is hereby granted, free of charge, to any person obtaining a copy of
 this software and associated documentation files (the "Software"), to deal in the
 Software without restriction, including without limitation the rights to use,
 copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the
 Software, and to permit persons to whom the Software is furnished to do so,
 subject to the following conditions:
 
 The above copyright notice and this permission notice shall be included in all copies
 or substantial portions of the Software.
 
 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 
 */

#ifndef _____CHUNK_____
#define _____CHUNK_____

#include <string>
#include <stack>
#include <iostream>
#include "chunkexpressionlib.h"
using namespace std;

class chunk
{
public:
	chunk( void );
	chunk( bool );
	chunk( const chunk & );
	~chunk( void );
	
	const chunk & operator = ( const chunk & );
	
	void add_index( int, int );
	string crunch( const string &, const string & );
	
	string name_from_chunk_id( int );
	
private:
		
	struct chunk_record
	{
		chunk_record( int i = 0, int j = 0, int k = 0 )
		{
			chunk_type = i;
			chunk_start = j;
			chunk_end = k;
		}
		
		int chunk_type;
		int chunk_start;
		int chunk_end;
	};
	
	int start_index;
	int stop_index;
	int chunk_type;
	bool input_type;
	bool to;
	stack < chunk_record > chunk_data;
};

#endif